<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Admin\ApplicationController;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::get('/', function () {
    
    return Redirect::to('admin/login');
    // return view('website.home');
});



////////////without login pages///////////////






/////////////////////////without login pages end // 















Route::get('/dashboard', function () {
    return view('dashboard');
})->middleware(['auth'])->name('dashboard');

require __DIR__.'/auth.php';



// Admin 
Route::namespace('Admin')->prefix('admin')->name('admin.')->group(function(){
    Route::namespace('Auth')->middleware('guest:admin')->group(function(){
        // login route
        Route::get('login','AuthenticatedSessionController@create')->name('login');
        Route::post('login','AuthenticatedSessionController@store')->name('adminlogin');
    });
    Route::middleware('admin')->group(function(){
        Route::get('dashboard','HomeController@index')->name('dashboard');

        //////////////start///////////////
        Route::get('admit_new_student','HomeController@admit_new_student')->name('admit_new_student');
        Route::get('students','HomeController@students')->name('students');        
        Route::get('students/{id}','HomeController@studentsEdit')->name('studentsEdit');        
        Route::get('parents','HomeController@parents')->name('parents');        
        Route::get('teachers','HomeController@teachers')->name('teachers');
        Route::get('view_results','HomeController@view_results')->name('view_results');
        Route::get('create_subjects','HomeController@create_subjects')->name('create_subjects');
        Route::get('manage_subjects','HomeController@manage_subjects')->name('admit_new_student');
        Route::get('create_classes','HomeController@create_classes')->name('create_classes');
        Route::get('create_section','HomeController@create_section')->name('create_section');
        Route::get('create_class_term','HomeController@create_class_term')->name('create_class_term');
        Route::get('detail_class_term','HomeController@detail_class_term')->name('detail_class_term');
        Route::get('manage_classes','HomeController@manage_classes')->name('manage_classes');
        Route::get('manage_grades','HomeController@manage_grades')->name('manage_grades');
        Route::get('manage_classe_attendance','HomeController@manage_classe_attendance')->name('manage_classe_attendance');
        Route::get('class_time_table','HomeController@class_time_table')->name('class_time_table');
        Route::get('school_calendar_and_schedules','HomeController@school_calendar_and_schedules')->name('school_calendar_and_schedules');
        Route::get('assignment','HomeController@assignment')->name('assignment');
        Route::get('create_results','HomeController@create_results')->name('create_results');
        Route::get('create_tearms_search','HomeController@create_tearms_search')->name('create_tearms_search');
        Route::get('view_tearms_search','HomeController@view_tearms_search')->name('view_tearms_search');
        Route::get('view_result_detail','HomeController@view_result_detail')->name('view_result_detail');
        Route::get('create_resutl_detail','HomeController@create_resutl_detail')->name('create_resutl_detail');
        Route::get('edit_results','HomeController@edit_results')->name('edit_results');
        Route::get('broadsheets','HomeController@broadsheets')->name('broadsheets');
        Route::get('result_image','HomeController@result_image')->name('result_image');
        Route::get('promote_student','HomeController@promote_student')->name('promote_student');
        Route::get('custom_report_card_data','HomeController@custom_report_card_data')->name('custom_report_card_data');
        Route::get('upload_e_learning','HomeController@upload_e_learning')->name('upload_e_learning');
        Route::get('computer_based_test','HomeController@computer_based_test')->name('computer_based_test');
        Route::get('cash_flow_report','HomeController@cash_flow_report')->name('cash_flow_report');
        Route::get('add_income_expense','HomeController@add_income_expense')->name('add_income_expense');
        Route::get('transactions','HomeController@transactions')->name('transactions');
        Route::get('payment_notification','HomeController@payment_notification')->name('payment_notification');
        Route::get('create_school_teachers','HomeController@create_school_teachers')->name('create_school_teachers');
        Route::get('create_other_staffs','HomeController@create_other_staffs')->name('create_other_staffs');
        Route::get('manage_teachers','HomeController@manage_teachers')->name('manage_teachers');
        Route::get('manage_other_staffs','HomeController@manage_other_staffs')->name('manage_other_staffs');
        Route::get('employee_payrole','HomeController@employee_payrole')->name('employee_payrole');
        Route::get('manage_pay_slip','HomeController@manage_pay_slip')->name('manage_pay_slip');
        Route::get('attendance_by_teacher','HomeController@attendance_by_teacher')->name('attendance_by_teacher');
        Route::get('send_emails','HomeController@send_emails')->name('send_emails');
        Route::get('send_sms','HomeController@send_sms')->name('send_sms');
        Route::get('create_notice','HomeController@create_notice')->name('create_notice');
        Route::get('manage_users','HomeController@manage_users')->name('manage_users');
        Route::get('school_setting','HomeController@school_setting')->name('school_setting');
        Route::get('manage_screach_card_pins','HomeController@manage_screach_card_pins')->name('manage_screach_card_pins');
        Route::get('manage_sessions','HomeController@manage_sessions')->name('manage_sessions');
        Route::get('manage_terms','HomeController@manage_terms')->name('manage_terms');
        Route::get('custom_fields','HomeController@custom_fields')->name('custom_fields');
        Route::get('school_setup','HomeController@school_setup')->name('school_setup');
        Route::get('currency_setting','HomeController@currency_setting')->name('currency_setting');
        Route::get('payment_gateway_setting','HomeController@payment_gateway_setting')->name('payment_gateway_setting');
        Route::get('list_fees','HomeController@list_fees')->name('list_fees');
        Route::get('view_for_fees','HomeController@view_for_fees')->name('view_for_fees');
        Route::get('view_for_fees_detail','HomeController@view_for_fees_detail')->name('view_for_fees_detail');
        Route::get('fee_payment_report','HomeController@fee_payment_report')->name('fee_payment_report');
        Route::get('mail_compose','HomeController@mail_compose')->name('mail_compose');
        Route::get('assign','HomeController@assign')->name('assign');
        Route::get('view_main_result','HomeController@view_main_result')->name('view_main_result');
        // Route::get('admit_new_student','HomeController@admit_new_student')->name('admit_new_student');
        /////////////end sidebar


        // action start
// Route::post('admin.application','HomeController@manage_application')->name('admin.application');
Route::post('/application/store', [ApplicationController::class,'store'])->name('admin.application.store');
Route::post('/application/update', [ApplicationController::class,'update'])->name('admin.application.update');
Route::post('application/updateEdit', [ApplicationController::class,'updateEdit'])->name('admin.application.updateEdit');
Route::post('create_classes', [ApplicationController::class,'create_classes'])->name('admin.application.store');
Route::post('create_sections', [ApplicationController::class,'create_sections'])->name('admin.application.store');
Route::post('create_classes_term', [ApplicationController::class,'create_classes_term'])->name('admin.application.store');
Route::post('create_tearm_detail', [ApplicationController::class,'create_tearm_detail'])->name('admin.application.store');

Route::post('/teacher/create', [ApplicationController::class,'create_teacher'])->name('admin.application.teacher');

Route::post('/subject/create', [ApplicationController::class,'create_subject'])->name('admin.application.create_subject');


Route::post('/assign/store/', [ApplicationController::class,'assignstore'])->name('admin.application.assignstore');
Route::post('/fees/assign/store/', [ApplicationController::class,'feesassignstore'])->name('admin.application.feesassignstore');
Route::post('/assign/store/', [ApplicationController::class,'assignstore'])->name('admin.application.assignstore');
Route::post('/fees/pay/now', [ApplicationController::class,'fees_pay_now'])->name('admin.application.fees_pay_now');

Route::post('/create/results/store', [ApplicationController::class,'create_results_store'])->name('admin.application.create_results_store');


        // post end
 Route::get('manage_application','HomeController@manage_application')->name('manage_application');


        Route::get('delete_class','HomeController@deleteclass')->name('deleteclass');
        Route::get('delete_section','HomeController@delete_section')->name('delete_section');
        Route::get('delete_subject','HomeController@deletesubject')->name('deletesubject');


        Route::get('assign/delete','HomeController@deleteAssign')->name('deleteAssign');

        




        Route::get('admin-test','HomeController@adminTest')->name('admintest');
        Route::get('editor-test','HomeController@editorTest')->name('editortest');

        Route::resource('posts','PostController');

    });
    Route::post('logout','Auth\AuthenticatedSessionController@destroy')->name('logout');
});

  




